import random
import pygame.display, pygame.time
import gui, map


monster_pics = map.get_map('monster_pics')


def get_pic(x, y):
  return monster_pics._data[y][x][0]


class Monster:
  can_flee = 1
  def __init__(self, game):
    self.game = game
    self.hp = self.hp
    self.console = gui.Console(160 + 16, 120 - 32, 16, 8)
  def refresh(self):
    screen = pygame.display.get_surface()
    self.console.draw(screen)
    self.game.draw_status(screen)
    pygame.display.update()
  def player_move(self):
    options = ['attack', 'drink potion']
    if self.can_flee: options.append('run')
    command = self.console.menu(options)
    if command == 0:
      damage = random.randrange(self.game.attack + 1) \
        - random.randrange(self.defense + 1)
      if damage <= 0:
        self.console.println('You miss.')
      else:
        self.console.println('You hit the %s -%d.' % (self.name, damage))
        self.hp -= damage
    elif command == 1:
      if self.game.potions:
        self.game.potions -= 1
        n = min(50, self.game.endurance * 10 - self.game.hp)
        self.game.hp += n
        self.console.println('You are healed +%d' % n)
      else:
        self.console.println('Oops!  You have no potions.')
    elif self.can_flee:
      if random.randrange(2):
        self.console.println('You escape.')
        return 1
      else:
        self.console.println('You fail to escape.')
    else:
      self.console.println('There is nowhere to run.')
  def attack(self):
    damage = random.randrange(self.attack + 1) \
      - random.randrange(self.game.defense + 1)
    if damage <= 0:
      self.console.println('The %s misses you.' % self.name)
    else:
      self.console.println('The %s hits you -%d.' % (self.name, damage))
      self.game.hp -= damage
  move = attack
  def encounter_message(self):
    self.console.println('You encounter a %s.' % self.name)
  def fight(self):
    self.encounter_message()
    screen = pygame.display.get_surface()
    screen.fill((0xff, 0xff, 0xff),
      (160 - 64 - 16 - 8, 120 - 32 - 8, 64 + 16, 64 + 16))
    screen.fill((0, 0, 0),
      (160 - 64 - 16 - 4, 120 - 32 - 4, 64 + 8, 64 + 8))
    screen.blit(self.pic, (160 - 64 - 16, 120 - 32))
    while 1:
      # Your attack
      self.refresh()
      if self.player_move():
        self.refresh()
        self.console.getch()
        return
      if self.hp <= 0:
        self.console.println(
          'Victory!  You gain %d experience and find %d gold.'
          % (self.xp, self.gp))
        self.game.xp += self.xp
        self.game.gp += self.gp
        self.refresh()
        self.console.getch()
        return 1
      self.refresh()
      pygame.time.delay(1000)
      # Enemy attack
      self.move()
      if self.game.hp <= 0:
        self.console.println('You are defeated.')
        self.refresh()
        self.console.getch()
        return 0


class King(Monster):
  can_flee = 0
  pic = get_pic(0, 0)
  attack = 25
  defense = 10
  hp = 100
  name = 'king'
  xp = 0
  gp = 0
  def encounter_message(self):
    self.console.println('Your father attacks.')
  

class Ghost(Monster):
  can_flee = 0
  pic = get_pic(1, 0)
  attack = 20
  defense = 15
  hp = 100
  name = 'ghost'
  xp = 0
  gp = 0
  def encounter_message(self):
    self.console.println('Your mother attacks.')
  

class Goblin(Monster):
  pic = get_pic(0, 1)
  attack = 1
  defense = 0
  hp = 5
  name = 'goblin'
  xp = 2
  gp = 1


class GoblinWarrior(Goblin):
  pic = get_pic(1, 1)
  xp = 4
  gp = 3
  name = 'goblin warrior'
  attack = 2
  hp = 10


class GoblinElite(GoblinWarrior):
  pic = get_pic(2, 1)
  xp = 8
  gp = 5
  name = 'goblin elite'
  attack = 3


class GoblinGhost(GoblinElite):
  pic = get_pic(3, 1)
  xp = 12
  gp = 10
  name = 'goblin ghost'
  attack = 3
  defense = 5


class ZombieWarrior(Monster):
  pic = get_pic(0, 2)
  xp = 16
  gp = 12
  name = 'zombie warrior'
  attack = 5
  defense = 5
  hp = 20


class WraithWarrior(ZombieWarrior):
  pic = get_pic(1, 2)
  xp = 24
  gp = 16
  name = 'wraith warrior'
  defense = 7


class GhostWarrior(WraithWarrior):
  pic = get_pic(2, 2)
  xp = 32
  gp = 24
  name = 'ghost warrior'
  defense = 8
  hp = 30


class Shade(Monster):
  pic = get_pic(0, 3)
  xp = 32
  gp = 32
  name = 'shade'
  defense = 10
  attack = 10
  hp = 10

