import map, gui, combat, game


entity_pics = map.get_map('entity_pics')


def get_pic(x, y):
  return entity_pics._data[y][x][0]


class Entity:
  def __init__(self, game, x, y, *args):
    self.game = game
    self.x = x
    self.y = y
    self.init(*args)
  def init(self): pass
  def update(self): pass
  def draw(self, target, x, y):
    if hasattr(self, 'pic'):
      target.blit(self.pic, (x, y))
  def bump(self, other):
    pass


class Avatar(Entity):
  pic = get_pic(0, 0)
  def move_up(self): self.move(0, -1)
  def move_down(self): self.move(0, 1)
  def move_left(self): self.move(-1, 0)
  def move_right(self): self.move(1, 0)
  def move(self, dx, dy):
    x = self.x + dx
    y = self.y + dy
    if self.game.map.get_bounds(x, y): return
    for e in self.game.entities:
      if e.x == x and e.y == y:
        if not e.bump(self): return
    self.x = x
    self.y = y
    self.game.update()


class King(Entity):
  pic = get_pic(1, 0)
  def bump(self, other):
    if self.game.state < 1:
      self.game.state = 1
      gui.message_box('King: "I know you want to be a hero, but I forbid you '
        'entering the haunted grove.  '
        'With your mother dead, I couldn\'t stand losing you."')
    elif self.game.state == 1:
      gui.message_box('King: "I still dream of your mother sometimes."')
    elif self.game.state == 2:
      self.game.state = 3
      gui.message_box('Rupert: "Tell me about my mother\'s death."')
      gui.message_box('King: "I already told you, she was murdered by witches '
        'in the forest."')
      gui.message_box('Rupert: "Her spirit is in a cave in the haunted '
        'grove.  I spoke to her."')
      gui.message_box('King: "Then I suppose you must know the truth.  '
        'Somehow your mother fell in with an evil cult of witches.  When I '
        'found out, I rode with a warband to crush the evil cult once and for '
        'all.  In my rage, I didn\'t see who I was fighting.  When the battle '
        'was over, I found your mother among the slain."')
      gui.message_box('King: "Now I must ask something of you.  Go back to '
        'the cave and defeat your mother\'s spirit.  I cannot stand to see '
        'her bound to this world."')
      sel = gui.menu('King: "Will you do this for me?"', ['Accept', 
        'Refuse'], 1)
      if sel == 1:
        gui.message_box('Rupert: "I will not fight my mother, you murderer."')
        gui.message_box('King: "You go too far.  Apologize."')
        gui.message_box('Rupert: "Never."')
        gui.message_box('King: "Then die."')
        if combat.King(self.game).fight(): self.game.ending = 1
      else:
        gui.message_box('Rupert: "I will do it."')
        gui.message_box('King: "I knew I could count on you.  Here, take '
          'this sword.  It will aid you."')
        self.game.set_weapon(4)
    elif self.game.state == 3:
      sel = gui.menu('King: "Is your mother\'s spirit released?"',
        ['"I\'m working on it."',
        '"Revenge will set her free."'], 1)
      if sel == 0:
        gui.message_box('King: "Good luck then."')
      else:
        gui.message_box('King: "You dare?  For that you die."')
        if combat.King(self.game).fight(): self.game.ending = 1


class WeaponMerchant(Entity):
  pic = get_pic(2, 0)
  def bump(self, other):
    choices = ['Buy %s for %d gp' % (game.weapons[i + 1], 10 * 2 ** (i * 2))
      for i in range(3)]
    sel = gui.menu('Merchant: "Would you like to buy a weapon?"', choices)
    if sel < 0: return
    price = 10 * 2 ** (sel * 2)
    if price > self.game.gp:
      gui.message_box("You can't afford it.")
    elif sel + 1 == self.game.weapon:
      gui.message_box("You already have one.")
    elif sel + 1 < self.game.weapon:
      gui.message_box("You already have something better.")
    else:
      self.game.gp -= price
      self.game.set_weapon(sel + 1)


class ArmorMerchant(Entity):
  pic = get_pic(3, 0)
  def bump(self, other):
    choices = ['Buy %s for %d gp' % (game.armors[i + 1], 20 * 2 ** (i * 2))
      for i in range(3)]
    sel = gui.menu('Merchant: "Would you like to buy armor?"', choices)
    if sel < 0: return
    price = 10 * 2 ** (sel * 2)
    if price > self.game.gp:
      gui.message_box("You can't afford it.")
    elif sel + 1 == self.game.armor:
      gui.message_box("You already have one.")
    elif sel + 1 < self.game.armor:
      gui.message_box("You already have something better.")
    else:
      self.game.gp -= price
      self.game.set_armor(sel + 1)


class Healer(Entity):
  pic = get_pic(5, 0)
  def bump(self, other):
    n = (self.game.endurance * 10 - self.game.hp + 9) / 10
    if n:
      if gui.menu('Healer: "I can heal you for %d gold."' % n,
        ['Accept', 'Decline']) == 0:
        if self.game.gp < n:
          gui.message_box('Not enough gold.')
        else:
          self.game.gp -= n
          self.game.hp = 10 * self.game.endurance
    else:
      gui.message_box('Healer: "Come to me if you ever need healing."')
  

class ForestHealer(Healer):
  pic = get_pic(9, 0)


class PotionsMerchant(Entity):
  pic = get_pic(6, 0)
  def bump(self, other):
    if gui.menu('Merchant: "Would you like to buy a healing potion?  '
      'Only 10 gold."', ['Yes', 'No']) == 0:
      if self.game.gp < 10:
        gui.message_box('Not enough gold.')
      else:
        self.game.gp -= 10
        self.game.potions += 1


class Guard(Entity):
  pic = get_pic(7, 0)
  def bump(self, other):
    gui.message_box('Guard: "Be careful if you go near the haunted grove.  '
      'It was once inhabited by witches."')


class Peasant(Entity):
  pic = get_pic(8, 0)
  def bump(self, other):
    gui.message_box('Peasant: "Once I heard the wailing spirit of the haunted '
      'grove.  It sounded like it was coming from underground."')


class Ghost(Entity):
  pic = get_pic(4, 0)
  def bump(self, other):
    if self.game.state < 2:
      self.game.state = 2
      gui.message_box('Ghost: "Rupert!  How you\'ve grown.')
      gui.message_box('Prince Rupert: "Mother?"')
      gui.message_box('Ghost: "Yes, Rupert, it\'s me."')
      gui.message_box('Prince Rupert: "But how can that be?  Father told me '
        'you were murdered by witches in the forest."')
      gui.message_box('Ghost: "Did he now?  The bastard!"')
      gui.message_box('Ghost: "Rupert, I was one of those witches.  We were '
        'the last members of an old religion.  This cave was once our '
        'most sacred place.  We never harmed anybody, but we were different, '
        'so people feared us."')
      gui.message_box('Ghost: "When your father found out that I was one of '
        'them, he followed us here with a warband and slaughtered everyone.  '
        'He murdered me."')
      gui.message_box('Prince Rupert: "That is... unexpected.  I must think '
        'more on this."')
    elif self.game.state == 2:
      gui.message_box('Ghost: "Take care of yourself, Rupert."')
    elif self.game.state == 3:
      sel = gui.menu('Ghost: "Why have you returned?"',
        ['"I... miss you, mother."', '"I am here to fight you."'], 1)
      if sel == 0:
        gui.message_box('Ghost: "I miss you too, Rupert.  This cave is a '
          'terribly lonely place."')
      else:
        gui.message_box('Ghost: "So, another one of your line betrays me.  '
          'Like father like son, eh?  I had expected better of you, Rupert.  '
          'But at least this is one betrayal that I can avenge."')
        if combat.Ghost(self.game).fight(): self.game.ending = 2


class TransferPoint(Entity):
  def init(self, target_map, target_point):
    self.target_map = target_map
    self.target_point = target_point
  def bump(self, other):
    self.game.enter_map(self.target_map, self.target_point)
  
