import pygame.image


_maps = {}
_tilesets = {}


def get_map(name):
  if not _maps.has_key(name): _maps[name] = Map(name)
  return _maps[name]


def get_tileset(name):
  if not _tilesets.has_key(name): _tilesets[name] = TileSet(name)
  return _tilesets[name]


class TileSet:
  def __init__(self, name):
    bm = pygame.image.load('map_data/%s.bmp' % name)
    file = open('map_data/%s.txt' % name)
    tw, th, self.overlap = map(int, file.readline().split())
    num_tiles = int(file.readline())
    transparent = map(int, file.readline().split())
    file.close()
    bm.set_colorkey(transparent)
    h_tiles = bm.get_width() / tw
    self.tiles = [None] + [bm.subsurface(((i % h_tiles) * tw,
      (i / h_tiles) * th, tw, th)).convert() for i in range(num_tiles - 1)]
    for tile in self.tiles:
      if tile: tile.set_colorkey(transparent, pygame.RLEACCEL)
  def __getitem__(self, key): return self.tiles[key]


def _load_tile(ts, s):
  t = s.split()
  return ts[int(t[0])], int(t[1]), int(t[2])


class Map:
  # Attributes:
  #   _data: 2D array (list of lists) of tiles, where each tile is a
  #      [pic, bounds, code] list
  #   _tileset: reference to the tile set used by this map
  def __init__(self, name):
    self.name = name
    file = open('map_data/%s.txt' % name, 'r')
    self._tileset = get_tileset(file.readline()[:-1])
    w, h = map(int, file.readline().split())
    self._data = [[_load_tile(self._tileset, file.readline())
      for x in range(w)] for y in range(h)]

  def draw(self, target, tx, ty, sx, sy, w = 1, h = 1):
    overlap = self._tileset.overlap
    for iy in range(h):
      for ix in range(w):
        target.blit(self._data[iy + sy][ix + sx][0],
          (tx + ix * 16, ty + iy * 16 - overlap))
    
  def get_width(self): return len(self._data[0])
  def get_height(self): return len(self._data)
  def get_bounds(self, x, y): return self._data[y][x][1]
  def get_code(self, x, y): return self._data[y][x][2]

